﻿<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Handel.Forms" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Dokumenty z pozycjami</title>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
		
		    static DokumentyParams parametry;
		    
		    [Context(Required=false)]
		    public static DokumentyParams Parametry {
		        get { return parametry; }
                set { parametry = value; }
		    }
		    
            void Grid_ItemsGet(object sender, ItemsGetEventArgs args) {
	            if (args.Deep==1) {
		            DokumentHandlowy dokument = (DokumentHandlowy)args.Row;
		            args.Enumerable = dokument.Pozycje;
	            }
            }

            protected void Grid_BeforeRow(object sender, RowEventArgs args)
            {
                PozycjaDokHandlowego dokument = (PozycjaDokHandlowego)args.Row;
                colTowar.EditValue = HttpUtility.HtmlEncode(dokument.Towar.Kod + '\n' + dokument.Towar.Nazwa);
		        KwotaMarzy.EditValue = dokument.Suma.Netto - dokument.WartośćWCenieZakupuBuforKorygowana;
            }


            protected void dc_ContextLoad(object sender, EventArgs e) {
                if (Parametry != null) {
                    string partia = CaptionAttribute.EnumToString(Parametry.FiltrTypuPartii);
                    string typ = CaptionAttribute.EnumToString(Parametry.FiltrTypu);
                    string linia = "|Partia: <STRONG>" + partia + "</STRONG>, Typ: <STRONG>" + typ + "</STRONG>";
                    ReportHeader.Title += linia;
                }
            }
</script>
	</HEAD>
	<body>
		<form id="Form1" method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" title="Dokumenty z pozycjami</STRONG>|Magazyn:<STRONG> {0}</STRONG>" runat="server"
				DataMember0="Magazyn"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
				OnItemsGet="Grid_ItemsGet" GroupData0="Dokument.Data" GroupData1="Dokument.Numer" GroupData2="Dokument.Kontrahent" EncodeHtml="true"
				GroupLine="Data: {0} Dokument: {1} Kontrahent: {2}" ShowGroupSum="True" OnBeforeRow="Grid_BeforeRow">
				<Columns>
					<ea:GridColumn ID="GridColumn1" Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server"></ea:GridColumn>
					<ea:GridColumn runat="server" ID="colTowar" Caption="Towar" Align="Left" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn ID="GridColumn2" Width="10" Align="Right" DataMember="Ilosc" Caption="Ilość" runat="server"></ea:GridColumn>
                    <ea:GridColumn ID="GridColumn3" runat="server" Caption="Ilość do rozliczenia" Width="10" DataMember="Podrzędne.Faktura.PozostałoIlość" Align="Right">
                    </ea:GridColumn>
					<ea:GridColumn ID="GridColumn4" Width="14" Align="Right" DataMember="Cena" Caption="Cena~przed rabatem" runat="server"></ea:GridColumn>
					<ea:GridColumn ID="GridColumn5" Width="14" Align="Right" DataMember="CenaPoRabacie" Caption="Cena~po rabacie" runat="server"></ea:GridColumn>
					<ea:GridColumn ID="GridColumn6" Width="9" Align="Right" DataMember="Rabat" Caption="Rabat|%" runat="server"></ea:GridColumn>
					<ea:GridColumn ID="GridColumn7" Width="14" Align="Right" DataMember="WartoscCy" Caption="Wartość" runat="server"></ea:GridColumn>
                    <ea:GridColumn runat="server" Caption="Kwota marży na pozycji" Align="Right" ID="KwotaMarzy" EncodeHTML="True">
                    </ea:GridColumn>
					<ea:GridColumn ID="GridColumn8" Width="14" Align="Right" DataMember="ZmianaWartościCy2" Caption="Zmiana|wartości" runat="server"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</HTML>

